function [msg]=writeimg(imgFile,img,datatype,MachineFormat)
%[msg]=writeimg(imgFile,img,datatype,MachineFormat)
%write intensities to an img file
%Intput:
% imgFile: a string filename
% img: intensity data
% datatype: see fwrite()
% MachineFormat: 'ieee-be' or 'ieee-le'
%Output:
% msg: a short string
%
%20040318, jdlee
%

%check input paramters
if(nargin<1),
  error('no img filename');    
end

if(nargin<2),
  error('no img');    
end

if(nargin<3),
  error('no DataType');
end

if(nargin<4),
    error('no MachineFormat');
end

%I want img file
[path,name,ext] = fileparts(imgFile);
imgFile = fullfile(path,[name '.img']);

fid = fopen(imgFile,'wb',MachineFormat);
fwrite(fid,img,datatype);
fclose(fid);

return